<?php
/*
Plugin Name: WAO Tiendas
Text domain: woocommerce-pdf-invoices-packing-slips
Domain Path: /languages
Plugin URI: https://winandoffice.com
Description: Funciones exclusivas de las tiendas de Windows & Office..
Version: 2.4.8 (*Widget ventas dia con monto, Fecha renovacion, 21 dias widget, Borra paypals antiguos, Asignacion roles usuarios, Widget red ventas dia, Submenú Historial de cambios, Widget Bancos, Correccion en paypal-cpt-single)
Author: Arturo Zubieta
Author URI:https://winandoffice.com
License: GPL
*/
/*INDICE DEL Plugin
  =================
* AÑADIR LINK settings EN EL PLUGIN 33
* INSERTAR UN MENU "PARAMETROS FACTURA" EN SETTINGS DE WORDPRESS
  - FORMULARIO 
  - REGISTRO DE CAMPOS O VARIABLES EN LA BASE DE DATOS
  - VALIDACION
  - INPUTS PARA LOS CAMPOS DEL FORMULARIO EN EL FORMULARIO
  - CREAR LOS SHORTCODES
* AÑADIR PAYPAL RECEIVER EN CORREO Y PAGINA DE PEDIDO
* FACTURA A TRES COLUMNAS
* CREAR LA SEGUNDA PAGINA DE LA FACTURA
* WIDGET PAYPAL EN DASHBOARD
* USTIDNR Y MSPARTNER EN EL ENCABEZADO DE FACTURA
* COLOCAR EL TÍTULO DE LA PERSONA EN LA FACTURA
*/
//        load_plugin_textdomain( 'woocommerce-pdf-invoices-packing-slips', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
defined( 'ABSPATH' ) || exit;

include("wao-link.php");
include("wao-parametros-factura.php");
include("wao-paypal-receiver.php");
include("wao-factura3col.php");
include("wao-2da-pagina-factura.php");
include("paypals/paypal-entry-point.php");
include("mailtraintracking.php");
include("wao-shortcodes.php");
include("wao-banks-widget.php");
include("wao-dailysales-widget.php");

/////////ARTURO: USTIDNR Y MSPARTNER EN EL ENCABEZADO DE FACTURA
// Incluir NIF en la factura

add_filter( 'wpo_wcpdf_shop_address', 'incluir_ustidnr_en_factura' );

function incluir_ustidnr_en_factura( $address ){
	return scodes($address);
}
function scodes($texto){
	$options = get_option('_invoices_options'); //aqui esta la raiz de vertrag y lizenzgeber
	$texto=str_replace("[ustidnr]",$options["ustidnr"],$texto);
	$texto=str_replace("[mspartner]",$options["mspartner"],$texto);
	$texto=str_replace("[correo]",$options["correo"],$texto);
	$texto=str_replace("[direccion]",$options["direccion"],$texto);
	$texto=str_replace("[direccion2]",$options["direccion2"],$texto);
	$texto=str_replace("[telefono]",$options["telefono"],$texto);
	$texto=str_replace("[urltienda]",$options["urltienda"],$texto);
	return $texto;
}
///////FIN DE FUNCION INCLUIR NIF. FUNCION ANULADA, PARA INCLUIR ESTOS DATOS, VASTA COLOCAR SHORTCODES EN LA CONFIGURACION DE PDF INVOICES/General/Shop Addres

//////COLOCAR EL TÍTULO DE LA PERSONA EN LA FACTURA
add_action('wpo_wcpdf_before_billing_address','ponertitle',10,2);
function ponertitle($type,$orden){
	$title=get_post_meta($orden->ID,"title");
	if($title<>""){
		echo '<div class="billing-email">'.$title[0].'</div';
	}
}
//////FIN DE COLOCAR EL TÍTULO DE LA PERSONA EN LA FACTURA

//////NOMBRE Y COMPANIA EN FACTURA
add_action('wpo_wcpdf_before_billing_address','compania',10,2);
function compania($tipo,$orden){
	?>
    <span class="custom-text">
    <?php echo "&nbsp;";?>
    </span><br>
    <?php
}

//////FIN DE NOMBRE Y COMPANIA EN FACTURA

///FUNCIONES COMUNES

function tabla($el,$estilo="none"){
	return "<table class='".$estilo."'>".$el."</table>";
}
function tr($el,$estilo="none"){
	return "<tr class='".$estilo."'>".$el."</tr>";
}
function td($el, $estilo="none"){
	return "<td class='".$estilo."'>".$el."</td>";
}
function tag($el,$tipo="b",$estilo="none"){
	return "<".$tipo."  class='".$estilo."'>".$el."</".$tipo.">";
}



?>